//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	Australian Residents - Inheritance Inflows
// Objective: 	Estimate the annual value of inheritances received by people
//				whose entire family resides in Australia.
//
// Created: 	29/07/2021
// Modified: 	15/11/2021
//==============================================================================

****************
*** Bequests ***
****************

*************************************
*** Loading and cleaning the data ***
*************************************

clear

cd "XXXX" 	// set content directory here

* For Australian residents comparison
use HILDA_restricted_combined_rescaled_domestic_parents_siblings

replace oifinha = . if oifinha <= 0	// replacing negative values for bequests as missing
replace oifinh = . if oifinh != 1	// replacing zero values for receiving a bequest as missing

merge 1:1 xwaveid wave using "first_estate_bequest.dta"	// merging in spouse bequest flag

drop if first_estate_bequest == 1	// dropping likely inheritances from spouses

****************************************
*** Generating population aggregates ***
****************************************

gen pop_oifinha = oifinha * benchmarked_new_hhwtrp	// multiplying bequests received by the responding-person population weights

by wave, sort: egen sum_bequest = sum(pop_oifinha)	// calculating the aggregate value of bequests received each year

collapse(mean) sum_bequest, by(wave)	// collapsing the dataset and keeping the key summary statistics for each year

*************************************
*** Exporting and saving the data ***
*************************************

gen year = wave + 2000	// generating a year variable

keep year sum_bequest	// keeping the year and total bequests received variables to compare to outflow measures

merge 1:1 year using CPI_FY_2018.dta, nogen	// merging in financial-year CPI data with 2018 base year

drop if year == 2020	// dropping years for which there are no observations

replace sum_bequest = sum_bequest * (100 / cpi)	// converting to constant 2018 dollars

tset year	// setting time variable

gen sum_bequest_cal = (sum_bequest + F.sum_bequest) / 2	// creating calendar year averages

keep year sum_bequest_cal	// keeping relevant varaibles

rename sum_bequest_cal sum_bequest

* For Australian residents comparison
save "Australian Residents - Inheritance Inflows", replace
